define(['angular', 'app'], function (angular, app) {
    'use strict';

    app.service('GoalGraphAccessibilityService', function($filter) {
        var service = {};

        service.getScreenReaderTexts = function(data) {
            return {
                minutes: getItemText('minutes', data),
                steps:   getItemText('steps', data),
                miles:   getItemText('miles', data)
            };
        };

        var getItemText = function(item, data) {
            var noGoalVerbiage = 'You have not set a ' + item + ' goal. Select the Weekly Activity Goals button to set a ' + item + ' goal.';
            var numDecimals = item === 'miles' ? 1 : 0;
            var progress = (data.progress && data.progress[item]) ?
                $filter('number')(data.progress[item], numDecimals) : 'zero';
            var yesGoalVerbiage;
            if((data.target && data.target[item])) {
                yesGoalVerbiage = 'You have completed ' + progress + ' ' + item +
                    ' toward your goal of ' + $filter('number')(data.target[item], 0) + ' ' + item + '.';
            }

            return (data.target && data.target[item]) ? yesGoalVerbiage : noGoalVerbiage;
        };

        return service;
    });
});
